(defmeth homals-proto :save-model-template (data-object)
"Args: (data-object)
DATA-OBJECT is the object-identification information of a data object. 
The method contains a template for saving the model-object." 
  `(homogeneity-analysis
    :title      ,(send self :title)
    :name       ,(send self :name) 
    :dialog      nil
    :data (data  ,(send data-object :name)
                 :title      ,(send data-object :title)
                 :variables ',(send self :variables)
                 :labels    ',(send self :labels)
                 :data      ',(send self :data)))
  )


(defmeth HOMALS-proto :create-data 
  (&key (dialog nil)
        (scores t)
        (quantification nil)
        (d-m nil)
        (input  nil))

  (if (not (eq current-object self)) (setcm self)) 
  (let ((creator (send *desktop* :selected-icon))
        (desires (list (list (if scores 0) 
                             (if quantification 1)
                             
                             )))
        )
    (cond 
      (dialog
       (setf desires 
             (choose-subset-dialog "Choose Desired Data Objects"
                  '("Object Scores"
                    "Category Quantifications"
                   )
                   :initial (select desires 0))))
      (t
       (setf desires 
             (list (list (if scores 0)
                         (if (and set-coefs  coefs ) 1)
                         (if quantification 2)
                         )))))
    
    (when desires
          (when (member '0 (select desires 0))
                (send current-model :HOMALS-scores-data-object creator))
          (when (member '1 (select desires 0))
                (send current-model :HOMALS-quantification-data-object  creator)))
    (not (not desires))))

(defmeth HOMALS-proto :HOMALS-scores-data-object (creator)
  (data (strcat "Object Scores-" (send self :name))
   :created creator
   :creator-object self
   :title (strcat "HOMALS Objects Scores for " (send self :title))
   :data  (combine (send self :z))


   :variables (mapcar #'(lambda (x) (format nil "DIM~a" x)) 
                             (1+ (iseq (min (send self :p) (send self :n)))))
          :labels (send self :labels)
          :types (repeat "Numeric" (min (send self :p) (send self :n))))
    )

(defmeth HOMALS-proto :HOMALS-quantification-data-object (creator)
  (data (strcat "Category Quantifications-" (send self :name))
   :created creator
   :creator-object self
   :title (strcat "HOMALS Category Quantifications for " (send self :title))
   :data  (combine (send self :y))


   :variables (mapcar #'(lambda (x) (format nil "DIM~a" x)) 
                             (1+ (iseq (send self :p))))
          :labels (combine (send self :category-labels))
          :types (repeat "Numeric" (iseq (send self :p))))
    )







